#pragma once

#include "playercore/MediaType.hpp"
#include "playercore/ReferenceClock.hpp"
#include <map>

namespace twitch {
class MediaClock : public ReferenceClock {
public:
    MediaClock();
    ~MediaClock() override = default;

    MediaTime getElapsedWallClockTime() const override;
    MediaTime getElapsedMediaTime() const override;
    MediaTime getMediaTime() const override;
    MediaTime getMediaStartTime() const { return m_startTime; }
    MediaTime getAudioTime() const;
    MediaTime getVideoTime() const;
    float getPlaybackRate() const override { return m_playbackRate; };
    void reset();
    void setDiscontinuity(bool discontinuity);
    void setTime(MediaTime time);
    void setTime(const MediaType& type, MediaTime time);
    void setPlaybackRate(float rate);
    MediaTime now() const override;
    void start() override;
    void stop() override;

private:
    MediaTime m_currentTime;
    MediaTime m_startTime;
    MediaTime m_wallClockStart;
    MediaTime m_wallClockElapsed;
    bool m_started;
    float m_playbackRate;
    std::map<MediaType, MediaTime> m_renderTimes;
};
}
