#include "MetadataRenderer.hpp"

namespace twitch {
MetadataRenderer::MetadataRenderer(Listener& listener, const ReferenceClock& clock)
    : m_listener(listener)
    , m_presentationTime(MediaTime::zero())
    , m_clock(clock)
{
}

MediaResult MetadataRenderer::configure(const MediaFormat& format)
{
    (void)format;
    return MediaResult::Ok;
}

MediaResult MetadataRenderer::render(std::shared_ptr<const MediaSample> input)
{
    // wait until this sample should be presented
    MediaTime now = m_clock.getMediaTime();
    MediaTime wait = MediaTime::zero();
    if (now.valid() && now > MediaTime::zero()) {
        wait = (input->presentationTime - now) / m_clock.getPlaybackRate();
    }
    if (wait > MediaTime::zero()) {
        if (!m_listener.onTimedWait(wait)) {
            // wait cancelled
            return MediaResult::Ok;
        }
    }
    m_presentationTime = input->presentationTime;
    m_listener.onMetadataSample(std::static_pointer_cast<const MediaSampleBuffer>(input));
    return MediaResult::Ok;
}

MediaResult MetadataRenderer::getRenderedPresentationTime(MediaTime& time)
{
    time = m_presentationTime;
    return MediaResult::Ok;
}

MediaResult MetadataRenderer::setPlaybackRate(float rate)
{
    (void)rate;
    return MediaResult::Ok;
}
}
