#pragma once

#include "playercore/MediaRenderer.hpp"
#include "playercore/MediaSink.hpp"
#include "playercore/ReferenceClock.hpp"

namespace twitch {
/** Fires metadata through an event synced to the a/v tracks */
class MetadataRenderer : public MediaRenderer {
public:
    class Listener {
    public:
        virtual ~Listener() = default;
        virtual void onMetadataSample(std::shared_ptr<const MediaSampleBuffer> sample) = 0;
        virtual bool onTimedWait(MediaTime time) = 0;
    };
    MetadataRenderer(Listener& listener, const ReferenceClock& clock);
    ~MetadataRenderer() override = default;

    MediaResult flush() override { return MediaResult::Ok; };
    MediaResult start() override { return MediaResult::Ok; };
    MediaResult stop() override { return MediaResult::Ok; };
    MediaResult configure(const MediaFormat& format) override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult setPlaybackRate(float rate) override;

private:
    Listener& m_listener;
    MediaTime m_presentationTime;
    const ReferenceClock& m_clock;
};
}
