#include "NullAudioRenderer.hpp"
#include <thread>

namespace twitch {

MediaResult NullAudioRenderer::flush()
{
    m_lastRenderedTime = MediaTime::zero();
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::start()
{
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::stop()
{
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::configure(const MediaFormat&)
{
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::render(std::shared_ptr<const MediaSample> input)
{
    std::this_thread::sleep_for(input->duration.microseconds());
    m_lastRenderedTime = input->presentationTime;
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::getRenderedPresentationTime(MediaTime& time)
{
    time = m_lastRenderedTime;
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::setPlaybackRate(float)
{
    return MediaResult::Ok;
}

MediaResult NullAudioRenderer::setVolume(float)
{
    return MediaResult::Ok;
}
}
