#pragma once

#include "playercore/MediaRenderer.hpp"
#include <queue>

namespace twitch {

class NullAudioRenderer : public AudioRenderer {
public:
    NullAudioRenderer() = default;
    ~NullAudioRenderer() override = default;

    // MediaRenderer
    MediaResult flush() override;
    MediaResult start() override;
    MediaResult stop() override;
    MediaResult configure(const MediaFormat& format) override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult setPlaybackRate(float rate) override;

    // AudioRenderer
    MediaResult setVolume(float volume) override;

private:
    MediaTime m_lastRenderedTime = MediaTime::zero();
};
}
