#include "NullVideoRenderer.hpp"

namespace twitch {
MediaResult NullVideoRenderer::flush()
{
    m_lastRenderedTime = MediaTime::zero();
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::start()
{
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::stop()
{
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::configure(const MediaFormat&)
{
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::render(std::shared_ptr<const MediaSample> input)
{
    m_lastRenderedTime = input->presentationTime;
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::getDroppedFrames(int& count)
{
    count = 0;
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::getRenderedFrames(int& count)
{
    count = 0;
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::getRenderedPresentationTime(MediaTime& time)
{
    time = m_lastRenderedTime;
    return MediaResult::Ok;
}

MediaResult NullVideoRenderer::setPlaybackRate(float)
{
    return MediaResult::Ok;
}
}
