#pragma once

#include "playercore/MediaRenderer.hpp"
#include "playercore/platform/VideoRenderer.hpp"
#include <queue>

namespace twitch {
class NullVideoRenderer : public virtual VideoRenderer {
public:
    NullVideoRenderer() = default;
    ~NullVideoRenderer() override = default;

    MediaResult flush() override;
    MediaResult start() override;
    MediaResult stop() override;
    MediaResult configure(const MediaFormat& format) override;
    MediaResult render(std::shared_ptr<const MediaSample> input) override;
    MediaResult getDroppedFrames(int& count) override;
    MediaResult getRenderedFrames(int& count) override;
    MediaResult getRenderedPresentationTime(MediaTime& time) override;
    MediaResult setPlaybackRate(float rate) override;

private:
    MediaTime m_lastRenderedTime = MediaTime::zero();
};
}
