#include "PassthroughDecoder.hpp"

namespace twitch {
MediaResult PassthroughDecoder::configure(const MediaFormat& input, MediaFormat& output)
{
    output = input;
    return MediaResult::Ok;
}

MediaResult PassthroughDecoder::decode(const MediaSampleBuffer& input)
{
    if (!input.isDecodeOnly) {
        m_samples.push(input);
    }
    return MediaResult::Ok;
}

MediaResult PassthroughDecoder::flush()
{
    return MediaResult::Ok;
}

MediaResult PassthroughDecoder::reset()
{
    m_samples = std::queue<MediaSampleBuffer>();
    return MediaResult::Ok;
}

MediaResult PassthroughDecoder::hasOutput(bool& hasOutput)
{
    hasOutput = !m_samples.empty();
    return MediaResult::Ok;
}

MediaResult PassthroughDecoder::getOutput(std::shared_ptr<MediaSample>& output)
{
    if (m_samples.empty()) {
        return MediaResult::Error;
    }

    output = std::make_shared<MediaSampleBuffer>(m_samples.front());
    m_samples.pop();
    return MediaResult::Ok;
}
}
