#pragma once

#include "playercore/MediaDecoder.hpp"
#include <queue>

namespace twitch {
class PassthroughDecoder : public MediaDecoder {
public:
    PassthroughDecoder() = default;
    ~PassthroughDecoder() override = default;

    MediaResult configure(const MediaFormat& input, MediaFormat& output) override;
    MediaResult decode(const MediaSampleBuffer& input) override;
    MediaResult flush() override;
    MediaResult reset() override;
    MediaResult hasOutput(bool& hasOutput) override;
    MediaResult getOutput(std::shared_ptr<MediaSample>& output) override;

private:
    std::queue<MediaSampleBuffer> m_samples;
};
}
