#pragma once

#include "debug/PrefixLog.hpp"
#include "playercore/MediaFormat.hpp"
#include "playercore/MediaSample.hpp"
#include "playercore/platform/NativePlatform.hpp"
#include <queue>

namespace twitch {
class TrackBuffer {
public:
    TrackBuffer(const Platform& platform, const MediaType& mediaType);
    ~TrackBuffer() = default;
    TrackBuffer(const TrackBuffer&) = delete;
    const TrackBuffer& operator=(const TrackBuffer&) = delete;

    bool isEmpty() { return m_queue.empty(); }
    void clear() { m_queue.clear(); }
    void pop() { m_queue.pop_front(); }
    size_t size() { return m_queue.size(); }

    void push(const std::shared_ptr<const MediaFormat>& format);
    void push(const std::shared_ptr<MediaSampleBuffer>& sample);
    bool hasPresentationTime(MediaTime time);
    void remove(const TimeRange& range);
    MediaTime removeToSyncFrame();
    void seek(MediaTime seekTime);

    struct Item {
        std::shared_ptr<const MediaFormat> format;
        std::shared_ptr<MediaSampleBuffer> sample;

        Item() = default;
        explicit Item(std::shared_ptr<MediaSampleBuffer> sample)
            : format()
            , sample(std::move(sample))
        {
        }
        explicit Item(std::shared_ptr<const MediaFormat> format)
            : format(std::move(format))
            , sample()
        {
        }
    };

    const Item& front() { return m_queue.front(); }

private:
    void remove(const TimeRange& range, bool seeking);
    void removeBack(MediaTime time);

    std::deque<Item> m_queue;
    PrefixedLog m_log;
    bool m_isVideo;
    bool m_reorderSamples;
    bool m_checkOverlap;
};
}
