#include "TrackStatistics.hpp"

namespace twitch {
TrackStatistics::TrackStatistics()
{
    reset();
}

void TrackStatistics::decodedFrame()
{
    m_decodedFrames++;
}

void TrackStatistics::renderedFrame()
{
    m_renderedFrames++;
    m_frameRate.add(1);
}

bool TrackStatistics::update(const MediaSampleBuffer& sample, MediaTime end)
{
    decodedFrame();
    m_bitRate.add(static_cast<int>(sample.buffer.size() * 8));

    static const MediaTime StatsUpdateInterval(1.0);
    auto elapsed = end - m_start;

    if (elapsed > StatsUpdateInterval) {
        m_bitRate.elapsed(elapsed);
        m_frameRate.elapsed(elapsed);
        m_start = end;
        return true;
    }

    return false;
}

void TrackStatistics::reset()
{
    m_start = MediaTime::zero();
    m_droppedFrames = 0;
    m_decodedFrames = 0;
    m_renderedFrames = 0;
    m_frameRate.reset();
    m_bitRate.reset();
}
}
