#pragma once

#include "abr/TimedMovingAverage.hpp"
#include "playercore/MediaSample.hpp"
#include "playercore/Statistics.hpp"

namespace twitch {
class TrackStatistics : public Statistics {
public:
    TrackStatistics();
    int getFrameRate() const override { return m_frameRate.average(); }
    int getBitRate() const override { return m_bitRate.average(); }
    int getDecodedFrames() const override { return m_decodedFrames; }
    int getDroppedFrames() const override { return m_droppedFrames; }
    int getRenderedFrames() const override { return m_renderedFrames; }
    void setDroppedFrames(int value) { m_droppedFrames = value; }
    void setRenderedFrames(int value) { m_renderedFrames = value; }

    void decodedFrame();
    void renderedFrame();
    void reset();
    bool update(const MediaSampleBuffer& sample, MediaTime end);

private:
    MediaTime m_start;
    TimedMovingAverage<int> m_frameRate;
    TimedMovingAverage<int> m_bitRate;
    int m_droppedFrames;
    int m_decodedFrames;
    int m_renderedFrames;
};
}
