#pragma once

#include "TwitchLink.hpp"
#include "player/MediaRequest.hpp"
#include "playercore/platform/Platform.hpp"

namespace twitch {
/**
 * Source that takes a twitch clip url input parameter, e.g. https://clips.twitch.tv/<clip>
 * loads the clip metadata, loads the clip mp4 url as a source and provides quality select options.
 */
class ClipSource : public MediaSource {
public:
    ClipSource(MediaSource::Listener& listener,
        std::shared_ptr<Platform> platform,
        std::shared_ptr<Scheduler> scheduler,
        const TwitchLink& link);
    ~ClipSource() override;
    ClipSource(const ClipSource&) = delete;
    const ClipSource& operator=(const ClipSource&) = delete;

    void open() override;
    void close() override;
    void seekTo(MediaTime time) override;
    void read(const TimeRange& range) override;
    bool isLive() const override { return false; }
    bool isPassthrough() const override;
    bool isSeekable() const override;
    MediaTime getDuration() const override;
    const Quality& getQuality() const override;
    void setQuality(const Quality& quality, bool adaptive) override;
    const std::vector<Quality>& getQualities() const override;
    void setReadTimeout(MediaTime time) override;
    void setLowLatencyEnabled(bool) override {};

private:
    void createSource(const std::string& url);
    void onClipStatus(const std::string& content);
    void onRequestError(int error);
    void sendStatusRequest();

    MediaSource::Listener& m_listener;
    std::shared_ptr<Platform> m_platform;
    std::shared_ptr<Scheduler> m_scheduler;
    std::shared_ptr<HttpClient> m_httpClient;
    std::unique_ptr<MediaSource> m_source;
    TwitchLink m_link;
    std::vector<Quality> m_qualities;
    Quality m_selected;
    MediaRequest m_statusRequest;
    std::map<std::string, std::string> m_sources;
};
}
