#pragma once

#include "player/MediaRequest.hpp"
#include "playercore/platform/HttpClient.hpp"
#include "sink/DrmProvider.hpp"
#include "util/Uuid.hpp"

namespace twitch {
/**
 * Twitch specific integration using BuyDRM KeyOS license server.
 */
class DrmKeyOs : public DrmProvider {
public:
    DrmKeyOs(DrmProvider::Listener& listener, std::shared_ptr<HttpClient> httpClient, const Uuid& systemUuid);
    std::string getLicenseAcquisitionUrl() override;
    void onLicenseRequest(HttpRequest& request) override;
    void prepare(const MediaFormat& format) override;

private:
    void requestAuthXML(const std::string& channel, const std::string& token, const std::string& sig);
    void onResponse(HttpResponse& response);
    void onRequestError(MediaResult result, int error);

    DrmProvider::Listener& m_listener;
    std::shared_ptr<HttpClient> m_httpClient;
    Uuid m_systemId;
    MediaRequest m_request;
    std::string m_customdata;
    std::string m_contentPath;
};
}
