#include "LatencyStatistics.hpp"
#include <chrono>

namespace twitch {
void LatencyStatistics::generateServerOffset(double serverTime)
{
    using namespace std::chrono;
    auto unixNow = duration_cast<duration<double>>(system_clock::now().time_since_epoch());
    m_serverOffset = MediaTime(serverTime - unixNow.count());
}

void LatencyStatistics::update(MediaTime offset, MediaTime receiveTime, MediaTime sendTime)
{
    m_streamOffset = offset;
    using namespace std::chrono;
    auto unixNow = duration_cast<duration<double>>(system_clock::now().time_since_epoch());
    MediaTime serverTime(MediaTime(unixNow.count()) + m_serverOffset);
    m_broadcasterLatency = serverTime - receiveTime;
    m_transcoderLatency = serverTime - sendTime;
}
}
