#pragma once

#include "playercore/MediaTime.hpp"

namespace twitch {
class LatencyStatistics {
public:
    void generateServerOffset(double serverTime);
    void update(MediaTime offset, MediaTime receiveTime, MediaTime sendTime);
    MediaTime getBroadcasterLatency() const { return m_broadcasterLatency; }
    MediaTime getTranscoderLatency() const { return m_transcoderLatency; }

private:
    MediaTime m_serverOffset;
    MediaTime m_streamOffset;
    MediaTime m_broadcasterLatency;
    MediaTime m_transcoderLatency;
};
}
