#pragma once

#include "playercore/MediaSample.hpp"
#include "playercore/MediaTime.hpp"
#include <json11.hpp>
#include <string>

namespace twitch {
/** Parser for twitch specific metadata */
class MetadataParser {
public:
    enum class AdRollType {
        Pre,
        Mid,
        Post,
    };

    /** Callback interface used to signal events back to the player */
    class Listener {
    public:
        virtual ~Listener() = default;
        virtual void onMetaServerAdBreakStart(AdRollType rollType) = 0;
        virtual void onMetaServerAdBreakEnd() = 0;
        virtual void onMetaAdBreakRequested(MediaTime duration) = 0;
        virtual void onMetaLatencyTiming(MediaTime streamOffset, MediaTime receiveTime, MediaTime sendTime) = 0;
        virtual void onMetaSessionData(const std::map<std::string, std::string>& values) = 0;
    };

    static const std::string StitchedAdClass;
    static const std::string AssignmentClass;
    static const std::string StreamSourceClass;
    static const std::string AdTrigger;

    void onSample(const MediaSampleBuffer& sample, Listener& listener);

    AdRollType getAdRollType() const { return m_adRollType; }

private:
    AdRollType m_adRollType;
};
}
