#pragma once

#include "playercore/MediaTime.hpp"
#include <map>
#include <string>

namespace twitch {
/** Twitch HLS channel specific info from the master and media playlists which is non-standard */
class SessionData {
public:
    SessionData() = default;
    void clear();
    void reset(const std::map<std::string, std::string>& properties);
    void update(const std::map<std::string, std::string>& properties);
    const std::map<std::string, std::string>& getProperties() const { return m_info; }

    bool isLowLatency() const;
    bool isUltraLowLatency() const;
    bool isHoldbackGroup() const;
    double getServerTime() const;
    std::string getAdTriggerUrl() const;

private:
    std::map<std::string, std::string> m_info;
};
}
