#pragma once

#include "TwitchLink.hpp"
#include "playercore/platform/Platform.hpp"
#include <json11.hpp>
#include <map>
#include <string>

namespace twitch {
class TokenHandler {
public:
    explicit TokenHandler(std::shared_ptr<Platform> platform);

    void setAuthToken(const std::string& token);
    void setClientId(const std::string& id);
    const std::string& getPlayerType() { return m_playerType; }
    void setPlayerType(const std::string& type) { m_playerType = type; }
    void setUniqueId(const std::string& id);
    bool isPlayerCoreClientId() const;

    struct TokenResponse {
        std::string sig;
        std::string token;
    };
    const TokenResponse& getToken(const TwitchLink& link);
    void removeToken(const TwitchLink& link);
    std::string createAccessTokenRequest(const TwitchLink& link);
    const TokenResponse& parseTokenResponse(const TwitchLink& link, const std::string& content);
    const std::map<std::string, std::string>& getHeaders() { return m_headers; }

private:
    std::shared_ptr<Platform> m_platform;
    std::map<std::string, std::string> m_headers;
    std::string m_authToken;
    std::string m_clientId;
    std::string m_playerType;
    std::map<std::string, TokenResponse> m_tokens; // cached token responses
};
}
