#include "Base64.hpp"

namespace twitch {
namespace Base64 {
static const char g_encmap[] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'
};

static inline char encode3(uint8_t c) { return g_encmap[0x3F & c]; }
static inline char encode1(uint8_t a, uint8_t b) { return encode3(((a << 4) & 0x30) | ((b >> 4) & 0x0F)); }
static inline char encode2(uint8_t b, uint8_t c) { return encode3(((b << 2) & 0x3C) | ((c >> 6) & 0x03)); }
static inline char encode0(uint8_t a) { return encode3(a >> 2); }

std::string encode(const uint8_t* data, size_t size)
{
    std::string out;
    out.reserve(((size + 2) / 3) * 4);
    for (; 3 <= size; data += 3, size -= 3) {
        out.push_back(encode0(data[0]));
        out.push_back(encode1(data[0], data[1]));
        out.push_back(encode2(data[1], data[2]));
        out.push_back(encode3(data[2]));
    }

    switch (size) {
    default:
        break;
    case 2:
        out.push_back(encode0(data[0]));
        out.push_back(encode1(data[0], data[1]));
        out.push_back(encode2(data[1], 0));
        out.push_back('=');
        break;
    case 1:
        out.push_back(encode0(data[0]));
        out.push_back(encode1(data[0], 0));
        out.push_back('=');
        out.push_back('=');
        break;
    }

    return out;
}
////////////////////////////////////////////////////////////////////////////////
static const uint8_t g_decmap[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x3F,
    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
    0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x00, 0x00, 0x00, 0x00, 0x3F,
    0x00, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
    0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static inline uint8_t decode2(char c3, char c4) { return (g_decmap[0x7F & c3] << 6) | (g_decmap[0x7F & c4] >> 0); }
static inline uint8_t decode1(char c2, char c3) { return (g_decmap[0x7F & c2] << 4) | (g_decmap[0x7F & c3] >> 2); }
static inline uint8_t decode0(char c1, char c2) { return (g_decmap[0x7F & c1] << 2) | (g_decmap[0x7F & c2] >> 4); }

std::vector<uint8_t> decode(const char* data, size_t size)
{
    std::vector<uint8_t> out;
    out.reserve(((size + 1) * 3) / 4);

    // remove tailing '=' so we can unroll the remainder
    while (0 < size && '=' == data[size - 1]) {
        --size;
    }

    for (; 4 <= size; data += 4, size -= 4) {
        out.push_back(decode0(data[0], data[1]));
        out.push_back(decode1(data[1], data[2]));
        out.push_back(decode2(data[2], data[3]));
    }

    switch (size) {
    case 3:
        out.push_back(decode0(data[0], data[1]));
        out.push_back(decode1(data[1], data[2]));
        break;
    case 2:
        out.push_back(decode0(data[0], data[1]));
        break;
    default:
        break;
    }

    return out;
}
}
};
