#include "Hex.hpp"

namespace twitch {
namespace Hex {

const char g_encmap[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

std::string encode(const uint8_t* data, size_t size)
{
    std::string out;
    out.reserve(size * 2);
    for (; 0 < size; ++data, --size) {
        out.push_back(g_encmap[0x0F & (data[0] >> 4)]);
        out.push_back(g_encmap[0x0F & (data[0] >> 0)]);
    }
    return out;
}

const uint8_t g_decmap[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static uint8_t decode(char c1) { return g_decmap[0x7F & c1]; }
static uint8_t decode(char c1, char c2) { return (decode(c1) << 4) | decode(c2); }

std::vector<uint8_t> decode(const char* data, size_t size)
{
    std::vector<uint8_t> out;
    out.reserve((size + 1) / 2);
    if (size & 1) {
        // odd number for chars
        out.push_back(decode(data[0]));
        data += 1, size -= 1;
    }

    for (; 2 <= size; data += 2, size -= 2) {
        out.push_back(decode(data[0], data[1]));
    }

    return out;
}
}
};
