#pragma once
#include <cinttypes>
#include <cstring>
#include <string>
#include <vector>

namespace twitch {
namespace Hex {
std::string encode(const uint8_t* data, size_t size);
inline std::string encode(const std::vector<uint8_t>& data) { return encode(data.data(), data.size()); }
inline std::string encode(const std::string& data) { return encode((const uint8_t*)data.data(), data.size()); }

std::vector<uint8_t> decode(const char* data, size_t size);
inline std::vector<uint8_t> decode(const char* data) { return decode(data, strlen(data)); }
inline std::vector<uint8_t> decode(const std::string& data) { return decode(data.data(), data.size()); }
inline std::vector<uint8_t> decode(const std::vector<uint8_t>& data) { return decode(reinterpret_cast<const char*>(data.data()), data.size()); }
}
};
