#include "Random.hpp"
#include <chrono>

namespace twitch {
namespace Random {

using Clock = std::chrono::high_resolution_clock;
static std::mt19937 Generator(static_cast<unsigned int>(Clock::now().time_since_epoch().count()));

int integer(int lower, int upper)
{
    std::uniform_int_distribution<int> distribution(lower, upper);
    return distribution(Generator);
}

double real(double lower, double upper)
{
    std::uniform_real_distribution<double> distribution(lower, upper);
    return distribution(Generator);
}

std::chrono::milliseconds jitter(std::chrono::milliseconds jitter, std::chrono::milliseconds duration)
{
    int random = Random::integer(int((duration - jitter).count()), int((duration + jitter).count()));
    return std::chrono::milliseconds(random);
}

std::vector<uint8_t> buffer(size_t size)
{
    std::vector<uint8_t> data;
    data.reserve(size);
    std::uniform_int_distribution<int> distribution(0, 255);
    for (; size; --size) {
        data.push_back(static_cast<uint8_t>(distribution(Generator)));
    }
    return data;
}
}
}
