#pragma once

#include <map>
#include <string>

namespace twitch {
class UriBuilder {
public:
    UriBuilder(const std::string& scheme, const std::string& host, const std::string& path = std::string());
    void setPath(const std::string& path) { m_path = path; }
    void setPort(int port) { m_port = port; }
    void setParameter(const std::string& key, const std::string& value) { m_params[key] = value; }
    void setEncodedParameter(const std::string& key, const std::string& value);
    std::string build();

    static std::string encode(const std::string& string);
    static void getParametersFromUrl(const std::string& url, std::map<std::string, std::string>& values);

private:
    std::string m_scheme;
    std::string m_host;
    std::string m_path;
    int m_port;
    std::map<std::string, std::string> m_params;
};
}
