#pragma once

#include <array>
#include <cstdint>
#include <string>
#include <vector>

namespace twitch {
/**
 * Represents a Universally Unique Identifier (https://www.ietf.org/rfc/rfc4122.txt)
 */
struct Uuid {
    static Uuid fromString(const std::string& str);
    static Uuid fromBytes(const std::vector<uint8_t>& bytes);
    static Uuid random();

    std::vector<uint8_t> toBytes() const;
    std::string toString() const;
    std::string toString(const char* format) const;
    size_t printFormat(const char* format, char* buffer, size_t size) const;
    bool operator==(const Uuid& other) const;
    bool operator!=(const Uuid& other) const { return !(*this == other); }

    uint32_t timeLow;
    uint16_t timeMid;
    uint16_t timeHigh;
    uint16_t clockSeq;
    std::array<uint8_t, 6> node;
};
Uuid operator"" _uuid(const char* s, std::size_t n);
}
