#include "testenv.hpp"
#include "platforms/ios/ApplePlatform.h"
#import <CoreMedia/CoreMedia.h>
#import <AVFoundation/AVFoundation.h>

namespace twitch {
namespace test {
CALayer* g_layer = nil;
void setTestLayer(CALayer* layer)
{
    g_layer = layer;
}

std::shared_ptr<MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    auto player = std::make_shared<MediaPlayer>(listener, createPlatform());
    player->setSurface((__bridge void*) g_layer);
    return player;
}

std::shared_ptr<Platform> TestEnvironment::createPlatform()
{
    auto platform = std::make_shared<ApplePlatform>();

#ifdef ENABLE_LOOPBACK
    platform->setPassthroughMode(true);
#endif

    return platform;
}

void TestEnvironment::setUp() {};
void TestEnvironment::tearDown() {};

}
}
