#include "testenv.hpp"
#include "platforms/ios/ios_platform.h"

namespace twitch {
namespace test {
std::shared_ptr<MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    return std::make_shared<MediaPlayer>(listener, createPlatform());
}

std::shared_ptr<Platform> TestEnvironment::createPlatform()
{
    static auto platform = std::make_shared<ApplePlatform>();
    return platform;
}

void TestEnvironment::setUp() {};
void TestEnvironment::tearDown() {};
}
}
