#include "testenv.hpp"
#include "platforms/posix/PosixPlatform.hpp"
#include "player/MediaPlayer.hpp"

namespace twitch {
namespace test {
std::shared_ptr<MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    return std::make_shared<MediaPlayer>(listener, createPlatform());
}

std::shared_ptr<Platform> TestEnvironment::createPlatform()
{
    auto platform = std::make_shared<PosixPlatform>();
    return platform;
}

void TestEnvironment::setUp() {};
void TestEnvironment::tearDown() {};
}
}
