#include "testenv.hpp"
#include "display.hpp"
#include "nativeplayer.hpp"
#include "playercore/platform/ps4/PlayerCore.hpp"
#include "playercore/platform/ps4/PS4Platform.hpp"
#include <cassert>
#include <thread>

namespace twitch {
namespace test {
static NativePlayer sNativePlayer;
static std::thread sThread;
static int sNativePlayerCore = 0;

std::shared_ptr<Platform> TestEnvironment::createPlatform()
{
    if (!ps4::PlayerCore::isInitialized()) {
        ps4::PlayerCore::initialize();
    }

    auto onVideoFrameBuffer = std::bind(&Surface::onVideoFrameBuffer, sNativePlayer.display()->getSurface(0), std::placeholders::_1);
    auto onFrameNeedsReleasing = std::bind(&Surface::onFrameNeedsReleasing, sNativePlayer.display()->getSurface(0), std::placeholders::_1);
    auto platform = std::make_shared<PS4Platform>(onVideoFrameBuffer, onFrameNeedsReleasing);
    return platform;
}

std::shared_ptr<MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    return std::make_shared<MediaPlayer>(listener, createPlatform());
}

void TestEnvironment::setUp()
{
    sNativePlayer.initialize();

    if (!ps4::PlayerCore::isInitialized()) {
        ps4::Configuration config;
        config.deviceId = "team-player-core-testing";
        ps4::PlayerCore::initialize(config);
    }

    sThread = std::thread([]() {
        sNativePlayerCore = sNativePlayer.run();
    });
}

void TestEnvironment::tearDown()
{
    sNativePlayer.stop();
    //sNativePlayer.finalize(); // Fix me, so that gtest_repeat= can work on PS4
    sThread.join();
    sNativePlayer.finalize();
}
}
}
