#include "testenv.hpp"
#include "playercore/platform/windows/WindowsPlatform.hpp"
#include <wrl.h>
#include <wrl/client.h>
#include <dxgi1_4.h>
#include <d3d11.h>
#include <d3d11_3.h>
#include <ppltasks.h>

using namespace Microsoft;
using namespace Microsoft::WRL;

namespace twitch {
namespace test {

namespace
{
    Microsoft::WRL::ComPtr<ID3D11Device> g_device;
    twitch::WindowsPlatform::OnRenderFrame g_onRenderCallback;
}

void SetGraphicsOutputForTest(Microsoft::WRL::ComPtr<ID3D11Device> device, twitch::WindowsPlatform::OnRenderFrame onRenderCallback)
{
    g_device = device;
    g_onRenderCallback = onRenderCallback;
}

std::shared_ptr<twitch::Platform> TestEnvironment::createPlatform()
{
    auto platform = std::make_shared<WindowsPlatform>(g_device, g_onRenderCallback);
    return platform;
}

std::shared_ptr<twitch::MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    return std::make_shared<MediaPlayer>(listener, createPlatform());
}

void TestEnvironment::setUp() {};
void TestEnvironment::tearDown() {};
}
}
