#include "testenv.hpp"
#include "webtestenv.hpp"
#include "platforms/web/web-platform.hpp"
#include "platforms/web/web-mediaplayer.hpp"
#include "debug/PrintLog.hpp"
#include "debug/trace.hpp"

namespace twitch {
namespace test {

static WebMediaPlayer* s_testPlayer = nullptr;

void WebTestEnvironment::setPlayer(WebMediaPlayer* player)
{
    s_testPlayer = player;
}

std::shared_ptr<Platform> TestEnvironment::createPlatform()
{
    return s_testPlayer->getPlatform();
}

std::shared_ptr<MediaPlayer> TestEnvironment::createPlayer(Player::Listener& listener)
{
    s_testPlayer->setListener(&listener);
    // Player instance owned by web layer, so use a noop deleter
    return std::shared_ptr<MediaPlayer>(s_testPlayer, [](MediaPlayer*){});
}

void TestEnvironment::setUp()
{
}

void TestEnvironment::tearDown()
{
    s_testPlayer->setListener(nullptr);
    s_testPlayer->pause();
}

}
}
