#pragma once

#include "playercore/Player.hpp"

namespace twitch {
namespace test {
class EmptyPlayerListener : public Player::Listener {
public:
    EmptyPlayerListener() = default;

    void onDurationChanged(MediaTime duration) override
    {
        (void) duration;
    }

    void onError(const Error& error) override
    {
        (void) error;
    }

    void onMetadata(const std::string& type, const std::vector<uint8_t>& data) override
    {
        (void) type;
        (void) data;
    }

    void onPositionChanged(MediaTime position) override
    {
        (void) position;
    }

    void onQualityChanged(const Quality& quality) override
    {
        (void) quality;
    }

    void onRebuffering() override
    {
    }

    void onRecoverableError(const Error& error) override
    {
        (void) error;
    }

    void onSeekCompleted(MediaTime time) override
    {
        (void) time;
    }

    void onSessionData(const std::map<std::string, std::string>& properties) override
    {
        (void) properties;
    }

    void onStateChanged(Player::State state) override
    {
        (void) state;
    }

    void onAnalyticsEvent(const std::string& name, const std::string& properties) override
    {
        (void) name;
        (void) properties;
    }
};
}
}

