#include "callback_monitor.hpp"

namespace twitch {
namespace test {
PlayerCallbackMonitor::PlayerCallbackMonitor()
    : m_seekCompleted(false)
{
}

void PlayerCallbackMonitor::onSeekCompleted(twitch::MediaTime)
{
    {
        std::unique_lock<std::mutex> lock(m_mutex);
        m_seekCompleted = true;
    }
    m_condition.notify_all();
}

}
}
