#pragma once

#include "event.hpp"
#include "event_listener.hpp"
#include "event_monitor.hpp"
#include "debug/trace.hpp"
#include <cassert>

namespace twitch {
namespace test {
namespace EventReceiver {

template <typename Duration, typename... Args>
bool waitFor(Event<void(Args...)>* event,
    std::tuple<typename std::decay<Args>::type...>& received,
    Duration timeout,
    std::function<void()> test)
{
    EventMonitor<Args...> monitor;
    if (!monitor.subscribe(event)) {
        TRACE_ERROR("EventReceiver::waitFor(): Could not subscribe to event");
        assert(false);
        return false;
    }

    if (test) {
        test();
    }

    bool success = monitor.waitFor(timeout, received);
    if (!monitor.unsubscribe()) {
        TRACE_ERROR("EventReceiver::waitFor(): Could not unsubscribe from event");
        assert(false);
    }

    return success;
}
}
}
}
