#pragma once
#include "player/MediaPlayer.hpp"
#include <gtest/gtest.h>
#include "testenv.hpp"

namespace twitch {
class MediaPlayer;
class Platform;

class GTestEnvironment : public testing::Environment {
public:
    static GTestEnvironment* current;

    virtual std::shared_ptr<Platform> createPlatform() { return m_env->createPlatform(); }
    virtual std::shared_ptr<MediaPlayer> createPlayer(Player::Listener& listener)  { return m_env->createPlayer(listener); }
protected:
    GTestEnvironment();

    void SetUp() override { m_env->setUp(); }
    void TearDown() override { m_env->tearDown(); }

private:
    std::unique_ptr<test::TestEnvironment> m_env;
};
}
