#pragma once

// Common platform macros
#if defined(UWP)
#define PLAYERCORE_OS_UWP 1
#elif defined(_WINDOWS)
#define PLAYERCORE_OS_WINDOWS 1
#elif defined(_ORBIS)
#define PLAYERCORE_OS_PS4 1
#elif defined(IOS)
#define PLAYERCORE_OS_IOS 1
#elif defined(ANDROID)
#define PLAYERCORE_OS_ANDROID 1
#elif defined(EMSCRIPTEN)
#define PLAYERCORE_OS_WEB 1
#else
#define PLAYERCORE_OS_POSIX 1
#endif

#if PLAYERCORE_OS_PS4
#include <atomic>
#include <sce_atomic.h>
#elif !PLAYERCORE_OS_UWP && !PLAYERCORE_OS_WINDOWS
#include <unistd.h>
#endif

#include <atomic>

#if PLAYERCORE_OS_UWP
#include "playercore/platform/windows/WindowsPlatform.hpp"
#elif PLAYERCORE_OS_WINDOWS
#include "playercore/platform/windows/WindowsPlatform.hpp"
#elif PLAYERCORE_OS_PS4
#include "playercore/platform/ps4/PS4Platform.hpp"
#elif PLAYERCORE_OS_POSIX
#include "platforms/posix/PosixPlatform.hpp"
#endif

namespace twitch {
#if PLAYERCORE_OS_WINDOWS
using CurrentPlatform = WindowsPlatform;
#elif PLAYERCORE_OS_UWP
using CurrentPlatform = UwpPlatform;
#elif PLAYERCORE_OS_PS4
using CurrentPlatform = PS4Platform;
#elif PLAYERCORE_OS_POSIX
using CurrentPlatform = PosixPlatform;
#endif
}
