#pragma once
#include "playercore/Player.hpp"
#include <chrono>
#include <condition_variable>
#include <functional>
#include <gtest/gtest.h>
#include <list>
#include <mutex>
#include <string>
#include <utility>

/**
 * Monitor onError events reported by twitch::Player
 */
namespace twitch {
namespace test {
class PlayerErrorMonitor {
public:
    std::list<std::tuple<twitch::ErrorSource, twitch::MediaResult, std::string>> getErrors();

    void onError(const twitch::Error& error);

    template <typename DURATION>
    bool waitFor(twitch::ErrorSource source, twitch::MediaResult result, const std::string& message, std::function<void()> test, const DURATION& timeout)
    {
        auto microseconds = std::chrono::duration_cast<std::chrono::microseconds>(timeout);
        return waitFor(source, result, message, test, microseconds);
    }

    ::testing::AssertionResult waitFor(twitch::ErrorSource source, twitch::MediaResult error, const std::string& message, std::function<void()> test, std::chrono::microseconds timeout);

protected:
    std::list<std::tuple<twitch::ErrorSource, twitch::MediaResult, std::string>> m_errors;

    std::mutex m_mutex;
    std::condition_variable m_condition;
};
}
}
