#pragma once

#include "event.hpp"
#include "playercore/Player.hpp"
#include "EmptyPlayerListener.hpp"

namespace twitch {
namespace test {
class PlayerEventListener : public EmptyPlayerListener {
public:
    PlayerEventListener() = default;
    ~PlayerEventListener() override
    {
        onDurationChangedEvent.unsubscribeAll();
        onErrorEvent.unsubscribeAll();
        onMetadataEvent.unsubscribeAll();
        onQualityChangedEvent.unsubscribeAll();
        onRebufferingEvent.unsubscribeAll();
        onStateChangedEvent.unsubscribeAll();
        onTrackingEvent.unsubscribeAll();
    }

    Event<void(MediaTime duration)> onDurationChangedEvent;
    Event<void(ErrorSource source, MediaResult error, const std::string& message)> onErrorEvent;
    Event<void(const std::string& type, const std::vector<uint8_t>& data)> onMetadataEvent;
    Event<void(const Quality& quality)> onQualityChangedEvent;
    Event<void()> onRebufferingEvent;
    Event<void(Player::State state)> onStateChangedEvent;
    Event<void(const std::string& name, const std::string& properties)> onTrackingEvent;

    void onDurationChanged(MediaTime duration) override
    {
        onDurationChangedEvent(duration);
    }

    void onError(const Error& error) override
    {
        onErrorEvent(error.source, error.result, error.message);
    }

    void onMetadata(const std::string& type, const std::vector<uint8_t>& data) override
    {
        onMetadataEvent(type, data);
    }

    void onQualityChanged(const Quality& quality) override
    {
        onQualityChangedEvent(quality);
    }

    void onRebuffering() override
    {
        onRebufferingEvent();
    }


    void onStateChanged(Player::State state) override
    {
        onStateChangedEvent(state);
    }

    void onAnalyticsEvent(const std::string& name, const std::string& properties) override
    {
        onTrackingEvent(name, properties);
    }

};
}
}
