#include "player_state_machine.hpp"

namespace twitch {
namespace test {
template <>
const char* StateMachine<Player::State>::stateToString(Player::State state)
{
    return twitch::Player::stateToString(state);
}

PlayerStateMachine::StateTransitions PlayerStateMachine::ValidLiveStateTransitions{
    { Player::State::Idle, { Player::State::Playing, Player::State::Ready, Player::State::Buffering } },
    { Player::State::Ready, { Player::State::Buffering, Player::State::Idle } },
    { Player::State::Buffering, { Player::State::Playing, Player::State::Idle, Player::State::Ended } },
    { Player::State::Playing, { Player::State::Buffering, Player::State::Idle, Player::State::Ended } },
    { Player::State::Ready, { Player::State::Buffering } },
};

PlayerStateMachine::StateTransitions PlayerStateMachine::ValidVODStateTransitions{
    { Player::State::Idle, { Player::State::Playing, Player::State::Ready, Player::State::Buffering } },
    { Player::State::Ready, { Player::State::Buffering, Player::State::Idle } },
    { Player::State::Buffering, { Player::State::Playing, Player::State::Idle } },
    { Player::State::Playing, { Player::State::Buffering, Player::State::Idle, Player::State::Ended } },
    { Player::State::Ready, { Player::State::Buffering } },
};

PlayerStateMachine::PlayerStateMachine(Player::State current, bool isLive)
    : StateMachine(current, isLive ? ValidLiveStateTransitions : ValidVODStateTransitions)
{
}

}
}
