#include "player_state_timer.hpp"
#include <cassert>

namespace twitch {
namespace test {
PlayerStateTimer::PlayerStateTimer(twitch::Player::State state)
{
    // Timer won't be able to accurately track playback time if it already started in the Playing state
    assert(state == Player::State::Idle);

    // Include the Player's initial state
    onStateChanged(state);
}

PlayerStateTimer::~PlayerStateTimer()
{
}

std::chrono::microseconds PlayerStateTimer::getTime(twitch::Player::State state)
{
    auto now = std::chrono::system_clock::now();
    std::lock_guard<std::mutex> lock(m_mutex);

    auto playerStateTime = m_playerStateTimes[state];
    if (m_currentState == state) {
        return playerStateTime + std::chrono::duration_cast<std::chrono::microseconds>(now - m_currentStateStartTime);
    } else {
        return playerStateTime;
    }
}

void PlayerStateTimer::onStateChanged(Player::State state)
{
    auto now = std::chrono::system_clock::now();

    std::lock_guard<std::mutex> lock(m_mutex);
    m_playerStateTimes[state] += std::chrono::duration_cast<std::chrono::microseconds>(now - m_currentStateStartTime);

    m_currentState = state;
    m_currentStateStartTime = now;
}
}
}
