#pragma once

#include "playercore/Player.hpp"
#include "player_state_hash.hpp"
#include <chrono>
#include <mutex>
#include <map>

namespace twitch {
namespace test {
/**
 * Utility class that times how long the twitch::Player spends in each state
 */
class PlayerStateTimer {
public:
    PlayerStateTimer(twitch::Player::State state);
    ~PlayerStateTimer();

public:
    /**
     * Get the time that the player was in a given state
     *
     * @param state the player state of interest
     * @returns MediaTime in which the player was in the given state
     */
    std::chrono::microseconds getTime(twitch::Player::State state);

    /**
     * Handler to update the MediaPlayer's Player State
     */
    void onStateChanged(twitch::Player::State state);

protected:
    std::mutex m_mutex;

    twitch::Player::State m_currentState;
    std::chrono::system_clock::time_point m_currentStateStartTime;

    std::map<twitch::Player::State, std::chrono::microseconds> m_playerStateTimes;
};

}
}
