#include "quality_monitor.hpp"
#include <functional>

namespace twitch {
namespace test {
QualityMonitor::QualityMonitor(const twitch::Quality& quality)
{
    m_quality = quality;
}

void QualityMonitor::onQualityChanged(const Quality& quality)
{
    std::lock_guard<std::mutex> lock(m_mutex);
    m_quality = quality;
    m_condition.notify_one();
}

}
}
