#include "signalhandler.hpp"
#include "backtrace.hpp"
#include "debug/trace.hpp"
#include <csignal>
#include <cstdlib>
#include <thread>
#include <vector>

namespace twitch {
namespace test {
namespace SignalHandler {
static const std::vector<int> DefaultSignals({ SIGTERM,
    SIGSEGV,
    SIGILL,
    SIGABRT,
    SIGFPE });

void onSignal(int sig)
{
    auto threadId = std::this_thread::get_id();
    TRACE_ERROR("IntegrationTest::signalHandler(): Caught signal: %d (thread id=0x%p)", sig, threadId);

    BackTrace::print();

    // If the Jenkins job receives signal 11, the handler is called non-stop
    // and floods the console output
    if (sig == SIGSEGV) {
        std::exit(sig);
    }
}

void registerHandlers()
{
    for (const auto& sig : DefaultSignals) {
        std::signal(sig, onSignal);
    }
}
}
}
}
