#include "state_change_monitor.hpp"

namespace twitch {
namespace test {
PlayerStateChangeMonitor::PlayerStateChangeMonitor(twitch::Player::State state)
{
    // Include the Player's initial state
    onStateChanged(state);
}

void PlayerStateChangeMonitor::onStateChanged(Player::State state)
{
    std::lock_guard<std::mutex> lock(m_mutex);
    m_states.push_back(state);
    m_condition.notify_one();
}
}
}
