#include "test_util.hpp"
#include <cassert>
#include <gtest/gtest.h>
#include <iostream>

namespace twitch {
namespace test {
using namespace ::testing;
void TestUtil::printSkipTest(const std::string& message)
{
    const auto testInfo = UnitTest::GetInstance()->current_test_info();
    assert(testInfo);

    std::cout << "[  SKIPPED ] " << testInfo->test_case_name() << "." << testInfo->name() << " not supported";

    if (!message.empty()) {
        std::cout << " (" << message << ")";
    }

    std::cout << std::endl;
}
}
}
