#include "timed_test_runner.hpp"
#include <iostream>
#include <thread>

using namespace ::testing;
namespace twitch {
namespace test {
size_t TimedTestRunner::getNumIntervals() const
{
    return static_cast<size_t>(m_duration.count() / m_period.count());
}

const TimedTestRunner::time_t& TimedTestRunner::getTotalTestTime() const
{
    return m_totalTestTime;
}

bool TimedTestRunner::run(std::function<AssertionResult(time_t)> test)
{
    m_totalTestTime = time_t::zero();

    bool success = true;
    std::thread thread([&]() {
        auto testTimeStart = clock_t::now();

        for (size_t i = 1; i <= getNumIntervals(); i++) {
            // Sleep this thread until the next testing interval
            auto timeToWake = testTimeStart + i * m_period;
            auto sleepFor = timeToWake - clock_t::now();
            std::this_thread::sleep_for(sleepFor);

            m_totalTestTime += m_period;
            auto testResults = test(m_totalTestTime);

            EXPECT_TRUE(testResults);
            if (!testResults) {
                success = false;
                break;
            }
        }
    });

    thread.join();
    return success;
}

}
}
