#pragma once

#include "playercore/platform/Scheduler.hpp"
#include "player/MediaPlayer.hpp"
#include "test/common/testenv/testenv.hpp"
#include "test/common/util/event.hpp"
#include "test/common/util/EmptyPlayerListener.hpp"
#include "TestCase.hpp"
#include <string>
#include <vector>

namespace twitch {
namespace test {
class PlayerTestCase : public TestCase, public EmptyPlayerListener {
public:
    PlayerTestCase(const std::string& name, TestEnvironment& environment, std::shared_ptr<twitch::Scheduler> scheduler);
    virtual ~PlayerTestCase();
    virtual PlayerTestCase& action(std::function<void(PlayerTestCase& test)> func);
    virtual PlayerTestCase& awaitState(Player::State state);
    virtual PlayerTestCase& awaitError(const Error& error);
    virtual PlayerTestCase& awaitQualityChange(const Quality& quality);
    virtual PlayerTestCase& awaitSeeked();

    Player& getPlayer() { return *m_player; }

    Event<void(MediaTime duration)> onDurationChangedEvent;
    Event<void(const Error& error)> onErrorEvent;
    Event<void(const std::string& type, const std::vector<uint8_t>& data)> onMetadataEvent;
    Event<void(const Quality& quality)> onQualityChangedEvent;
    Event<void()> onRebufferingEvent;
    Event<void(Player::State state)> onStateChangedEvent;
    Event<void(const std::string& name, const std::string& properties)> onTrackingEvent;
    Event<void(MediaTime time)> onSeekedEvent;

    void onDurationChanged(MediaTime duration) override;
    void onError(const Error& error) override;
    void onMetadata(const std::string& type, const std::vector<uint8_t>& data) override;
    void onQualityChanged(const Quality& quality) override;
    void onRebuffering() override;
    void onRecoverableError(const Error& error) override;
    void onSeekCompleted(MediaTime time) override;
    void onSessionData(const std::map<std::string, std::string>& properties) override;
    void onStateChanged(Player::State state) override;
    void onAnalyticsEvent(const std::string& name, const std::string& properties) override;
    void onPositionChanged(MediaTime position) override;

private:
    TestEnvironment& m_environment;
    std::shared_ptr<MediaPlayer> m_player;
};
}
}
