#include "PlayerTestSuite.hpp"

namespace twitch {
namespace test {
PlayerTestSuite::PlayerTestSuite(TestEnvironment& environment) : m_environment(environment)
{
    std::shared_ptr<Platform> platform = environment.createPlatform();
    m_scheduler = platform->createScheduler("test");
}

PlayerTestCase& PlayerTestSuite::test(const std::string& name)
{
    auto testcase = std::make_shared<PlayerTestCase>(name, m_environment, m_scheduler);
    m_testCases.push_back(testcase);
    return *testcase;
}
}
}