#pragma once

#include "playercore/platform/Scheduler.hpp"
#include "player/MediaPlayer.hpp"
#include "PlayerTestCase.hpp"
#include "test/common/testenv/testenv.hpp"
#include <string>
#include <vector>

namespace twitch {
namespace test {
class PlayerTestSuite {
public:
    explicit PlayerTestSuite(TestEnvironment& environment);
    PlayerTestCase& test(const std::string& name);

    const std::vector<std::shared_ptr<TestCase>>& getCases() const { return m_testCases; }

private:
    TestEnvironment& m_environment;
    std::shared_ptr<Scheduler> m_scheduler;
    std::vector<std::shared_ptr<TestCase>> m_testCases;
};
}
}
