#pragma once

#include "Assertion.hpp"
#include "player/ScopedScheduler.hpp"
#include "TestLog.hpp"
#include <queue>
#include <string>
#include <vector>

namespace twitch {
namespace test {
class TestCase : public Assertion, private ScopedScheduler {
public:
    class Listener {
    public:
        Listener() = default;
        virtual ~Listener() = default;
        virtual void onTestCaseStart(const std::string& name) = 0;
        virtual void onTestCaseEnd(const std::string& name, bool success) = 0;
    };

    TestCase(std::string name, std::shared_ptr<Scheduler> scheduler);
    ~TestCase() override;
    virtual TestCase& describe(const std::string& description);
    virtual TestCase& next(std::function<void(TestCase& test)> func);
    virtual TestCase& await(std::function<void(TestCase& test)> func, float timeout);

    void run(Listener* listener);
    void resume();

    bool isSuccess() const;
    const std::string& getDescription() const;
    std::chrono::milliseconds getElapsed() const;

    void assertTrue(bool condition, const std::string& message) override;
    void assertFalse(bool condition, const std::string& message) override;
    void fail(const std::string& message) override;

private:
    void nextStep();
    void endTest();

    struct Step {
        float timeout = 0.0;
        std::function<void(TestCase& test)> func;
        std::shared_ptr<Cancellable> timeoutCancel;
    };

    std::shared_ptr<Scheduler> m_scheduler;
    std::string m_name;
    std::string m_description;
    std::vector<Step> m_steps;
    size_t m_step;
    bool m_success;
    std::chrono::system_clock::time_point m_start;
    std::chrono::system_clock::time_point m_end;
    Listener* m_listener;
};
}
}
